﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja miesięczna</title>
		<script runat="server">

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			miesiąc = new YearMonth(data);
		}
		
		YearMonth miesiąc;
		[Required]
        [Priority(10)]
        [Caption("Raport za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set { 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    static bool SzczególneSchorzenie(object sender, PracHistoria ph) {
        switch (ph.PFRON.TypSchorzeniaSOD) {
            case SzczególneSchorzeniaSOD.ChorobyNarząduWzroku:
            case SzczególneSchorzeniaSOD.ChorobyPsychiczne:
            case SzczególneSchorzeniaSOD.UpośledzeniaUmysłowe:
            case SzczególneSchorzeniaSOD.CałościoweZaburzeniaRozwojowe:
            case SzczególneSchorzeniaSOD.Epilepsja:
                return true;
        }

        return false;
    }
		        
    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
    string title;
    ZPCHR zpchr;

	void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        title = ReportHeader1.Title;
		
		KadryModule kadry = KadryModule.GetInstance(dc);
        Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(pars.Miesiąc.ToFromTo());

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Miesiąc.FirstDay;
            foreach (Pracownik pracownik in view) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in view)
                list.Add(pracownik);
        }

        bool jestZpchr = Soneta.Core.CoreModule.GetInstance(dc).Config.Firma.StatusZPChr.Posiada;
        zpchr = new ZPCHR(jestZpchr, pars.Miesiąc, ZPCHR.WarunkiNaliczania.PFRON, new ZPCHR.SzczególneSchorzenieDelegate(SzczególneSchorzenie));
        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
	}
	
	static void Msg(object obj) {
	}

	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = (OddzialFirmy)DataRepeater1.CurrentRow;
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

        Grid1.DataSource = zpchr.Dni(dict[of]);		
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        ZPCHR.DzieńInfo info = (ZPCHR.DzieńInfo)args.Row;
        decimal etaty = info.Etaty;
        if (etaty == 0)
            colProcent.EditValue = 0;
        else {
            decimal znaczny = info.EtatyZnaczny;
            decimal umiarkowany = info.EtatyUmiarkowanySchorzenia;
            colProcent.EditValue = new Percent((znaczny + umiarkowany) / etaty);
        }
    }
</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięczna" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
			    <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Raport o stanie zatrudnienia do wyliczenia ulgi na PFRON|&lt;/strong&gt;Raport za: &lt;strong&gt;%MIESIĄC%|&lt;/strong&gt;|&lt;strong&gt;%ODDZIAL%"
				    runat="server"></cc1:reportheader><FONT face="Tahoma"><FONT size="2"> </FONT></FONT>
			    <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				    <Columns>
					    <ea:GridColumn Width="5" RightBorder="Double" Align="Center" DataMember="#" Caption="|Dzień||(1)"
						    NoWrap="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Pracownicy" Total="Sum" Caption="Zatrudnienie w osobach~Pracownicy og&#243;łem|(2)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Niepełnosprawni" Total="Sum" Caption="Zatrudnienie w osobach~Niepełnosprawni og&#243;łem|(3)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Lekki" Total="Sum" Caption="Zatrudnienie w osobach~|Lekki|(4)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Umiarkowany" Total="Sum" Caption="Zatrudnienie w osobach~|Umiarkowany|(5)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Znaczny" Total="Sum" Caption="Zatrudnienie w osobach~|Znaczny|(6)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Etaty" 
                            Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Pracownicy og&#243;łem|(7)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyNiepełnosprawni" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Niepełnosprawni og&#243;łem|(8)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyLekki" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Lekki|(9)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyUmiarkowany" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Umiarkowany|(10)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyUmiarkowanySchorzenia" 
                            Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Umiarkowany|(schorz.)|(11)"
						    HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyZnaczny" Total="Sum" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Znaczny|(12)"
						    HideZero="True" Format="{0:n}" RightBorder="Double"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Caption="%|||(13)"
						    HideZero="True" Format="{0:n}" ID="colProcent"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>

